<?php
use yii\helpers\Url;
use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\popover\PopoverX;
use backend\models\Admin;
return [
    /*[
        'class' => 'kartik\grid\ExpandRowColumn',
        'value' => function ($model,$key,$index,$column) {
            return GridView::ROW_COLLAPSED;
        },
        'detail' => function ($model, $key, $index, $column) {
            return Yii::$app->controller->renderPartial('_expand-files', ['model' => $model]);
        },
        //'enableRowClick' => true,
        'expandOneOnly' => true,
        'expandIcon' => '<span>+</span>',
        'collapseIcon' => '<span>-</span>',
    ],*/
    [
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'id',
        'headerOptions' => ['class' => 'text-left', 'style' => 'width:50px;'],
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'filename',
    ],
    /*[
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'group',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'filetype',
        'headerOptions' => ['class' => 'text-left', 'style' => 'width:80px;'],
    ],*/
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'storedfilename',
        'value' => function ($model, $key, $index, $widget) {
            return explode('/',$model->storedfilename)[count(explode('/',$model->storedfilename))-1];
        },
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'size',
        'value' => function ($model, $key, $index, $widget) {
            return \Yii::$app->formatter->asShortSize( $model->size );
        },
    ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'bots',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'admin_id',
        'value'=>function ($model){
            return Admin::findOne(['id' => $model->admin_id])['login'];
        },
        
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'template' => '{delete}',
        'vAlign'=>'middle',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        /*'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          //'data-toggle'=>'tooltip',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'], */
    ],

];   